
from gurobipy import *

# Create a model
m = Model("Vitamins_Optimization")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_E")
x1 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_A")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_zinc")

# Objective function
m.setObjective(6*x0 + 3*x1 + 3*x2, GRB.MAXIMIZE)

# Constraints based on the given problem description
# Kidney support index constraints
m.addConstr(x0 + 2*x1 + x2 <= 121, name="kidney_support_index_total")
m.addConstr(2*x1 + x2 <= 121, name="kidney_support_index_vitamin_A_and_zinc")

# Digestive support index constraints
m.addConstr(21*x0 + 16*x2 >= 39, name="digestive_support_index_E_and_zinc_min")
m.addConstr(20*x1 + 16*x2 >= 33, name="digestive_support_index_A_and_zinc_min")
m.addConstr(21*x0 + 20*x1 + 16*x2 <= 133, name="digestive_support_index_total_max")
m.addConstr(21*x0 + 16*x2 <= 133, name="digestive_support_index_E_and_zinc_max")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin E: {x0.x}")
    print(f"Milligrams of Vitamin A: {x1.x}")
    print(f"Milligrams of Zinc: {x2.x}")
else:
    print("No optimal solution found")
