
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define variables
x0 = m.addVar(name="milligrams of vitamin E", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="milligrams of vitamin A", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="milligrams of zinc")

# Objective function
m.setObjective(6 * x0 + 3 * x1 + 3 * x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(x0 + 2 * x1 + x2 <= 296, name="kidney_support_index")
m.addConstr(21 * x0 + 20 * x1 + 16 * x2 <= 133, name="digestive_support_index_combined")
m.addConstr(20 * x1 + 16 * x2 >= 33, name="digestive_support_index_x1_x2")
m.addConstr(21 * x0 + 16 * x2 >= 39, name="digestive_support_index_x0_x2")
m.addConstr(2 * x1 + x2 <= 121, name="kidney_support_index_x1_x2")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin E: {x0.varValue}")
    print(f"Milligrams of vitamin A: {x1.varValue}")
    print(f"Milligrams of zinc: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
