
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
J = m.addVar(name="J", vtype=gp.GRB.INTEGER)
H = m.addVar(name="H", vtype=gp.GRB.INTEGER)
B = m.addVar(name="B", vtype=gp.GRB.INTEGER)
P = m.addVar(name="P", vtype=gp.GRB.INTEGER)
Bill = m.addVar(name="Bill", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(6.6 * J + 7.62 * H + 8.55 * B + 6.91 * P + 7.67 * Bill, gp.GRB.MAXIMIZE)

# Constraints
# Individual work quality ratings
m.addConstr(J == 1)
m.addConstr(H == 1)
m.addConstr(B == 1)
m.addConstr(P == 1)
m.addConstr(Bill == 1)

# Work quality ratings
m.addConstr(J + 7 * H + 3 * B + 4 * P + 8 * Bill <= 146)

# Paperwork competence ratings
m.addConstr(2 * J + 8 * H + 6 * B + 1 * P + 2 * Bill <= 164)

# Computer competence ratings
m.addConstr(8 * J + 1 * H + 7 * B + 8 * P + 1 * Bill <= 82)

# Combined work quality ratings
m.addConstr(J + 7 * H + 8 * Bill >= 20)
m.addConstr(J + 3 * B + 4 * P >= 20)
m.addConstr(J + 7 * H + 4 * P >= 20)
m.addConstr(J + 3 * B + 8 * Bill >= 20)
m.addConstr(J + 4 * P + 8 * Bill >= 20)
m.addConstr(J + 7 * H + 3 * B >= 20)

m.addConstr(J + 7 * H + 8 * Bill >= 27)
m.addConstr(J + 3 * B + 4 * P >= 27)
m.addConstr(J + 7 * H + 4 * P >= 27)
m.addConstr(J + 3 * B + 8 * Bill >= 27)
m.addConstr(J + 4 * P + 8 * Bill >= 27)
m.addConstr(J + 7 * H + 3 * B >= 27)

m.addConstr(J + 7 * H + 8 * Bill >= 29)
m.addConstr(J + 3 * B + 4 * P >= 29)
m.addConstr(J + 7 * H + 4 * P >= 29)
m.addConstr(J + 3 * B + 8 * Bill >= 29)
m.addConstr(J + 4 * P + 8 * Bill >= 29)
m.addConstr(J + 7 * H + 3 * B >= 29)

# ... (rest of the constraints)

# Bounds
m.addConstr(J + 4 * P <= 90)
m.addConstr(J + 7 * H <= 89)
m.addConstr(7 * H + 3 * B <= 144)
m.addConstr(3 * B + 4 * P <= 29)
m.addConstr(J + 7 * H + 3 * B <= 138)
m.addConstr(J + 7 * H + 4 * P <= 125)
m.addConstr(7 * H + 4 * P + 8 * Bill <= 81)
m.addConstr(J + 7 * H + 8 * Bill <= 134)
m.addConstr(7 * H + 3 * B + 8 * Bill <= 117)
m.addConstr(J + 7 * H + 3 * B + 4 * P + 8 * Bill <= 117)

# ... (rest of the bounds)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("J: ", J.varValue)
    print("H: ", H.varValue)
    print("B: ", B.varValue)
    print("P: ", P.varValue)
    print("Bill: ", Bill.varValue)
else:
    print("No solution found")
