
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
D = m.addVar(lb=0, name="hours_worked_by_Dale")
H = m.addVar(lb=0, name="hours_worked_by_Hank")

# Set the objective function
m.setObjective(4*D**2 + 6*D*H + 7*D, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*D + 4*H >= 29, name="min_computer_rating")
m.addConstr(-8*D + 6*H >= 0, name="linear_constraint")
m.addConstr(4*D + 4*H <= 70, name="max_computer_rating")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Dale: {D.x}")
    print(f"Hours worked by Hank: {H.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
