
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    dale_hours = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="dale_hours")
    hank_hours = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hank_hours")

    # Objective function
    model.setObjective(4 * dale_hours ** 2 + 6 * dale_hours * hank_hours + 7 * dale_hours, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4 * dale_hours + 4 * hank_hours >= 29, name="min_computer_competence")
    model.addConstr(-8 * dale_hours + 6 * hank_hours >= 0, name="linear_constraint")
    model.addConstr(4 * dale_hours + 4 * hank_hours <= 70, name="max_computer_competence")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Dale: {dale_hours.varValue}")
        print(f"Hours worked by Hank: {hank_hours.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
