
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
hamburgers = model.addVar(vtype=GRB.INTEGER, name="hamburgers")
black_beans = model.addVar(vtype=GRB.INTEGER, name="black_beans")
hot_dogs = model.addVar(vtype=GRB.CONTINUOUS, name="hot_dogs")

# Set objective function
model.setObjective(3 * hamburgers + 1 * black_beans + 5 * hot_dogs, GRB.MAXIMIZE)

# Add constraints
model.addConstr(24 * hamburgers + 13 * black_beans >= 87, "tastiness_hamburgers_black_beans_min")
model.addConstr(13 * black_beans + 16 * hot_dogs >= 30, "tastiness_black_beans_hot_dogs_min")
model.addConstr(21 * hamburgers + 25 * black_beans >= 38, "iron_hamburgers_black_beans_min")
model.addConstr(25 * black_beans + 24 * hot_dogs >= 41, "iron_black_beans_hot_dogs_min")

model.addConstr(13 * black_beans + 16 * hot_dogs <= 190, "tastiness_black_beans_hot_dogs_max")
model.addConstr(24 * hamburgers + 13 * black_beans <= 148, "tastiness_hamburgers_black_beans_max")
model.addConstr(24 * hamburgers + 13 * black_beans + 16 * hot_dogs <= 148, "tastiness_total_max")
model.addConstr(21 * hamburgers + 24 * hot_dogs <= 87, "iron_hamburgers_hot_dogs_max")
model.addConstr(25 * black_beans + 24 * hot_dogs <= 72, "iron_black_beans_hot_dogs_max")
model.addConstr(21 * hamburgers + 25 * black_beans <= 120, "iron_hamburgers_black_beans_max")
model.addConstr(21 * hamburgers + 25 * black_beans + 24 * hot_dogs <= 120, "iron_total_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Objective Value:', model.objVal)
    print('hamburgers:', hamburgers.x)
    print('black_beans:', black_beans.x)
    print('hot_dogs:', hot_dogs.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

