
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
hamburgers = m.addVar(name="hamburgers", vtype=gp.GRB.INTEGER)
black_beans = m.addVar(name="black_beans", vtype=gp.GRB.INTEGER)
hot_dogs = m.addVar(name="hot_dogs")

# Define the coefficients for the objective function
obj_coeffs = [3, 1, 5]

# Define the objective function
m.setObjective(obj_coeffs[0] * hamburgers + obj_coeffs[1] * black_beans + obj_coeffs[2] * hot_dogs, gp.GRB.MAXIMIZE)

# Define the constraints
# Resource coefficients
r0 = {'hamburgers': 24, 'black beans': 13, 'hot dogs': 16}
r1 = {'hamburgers': 21, 'black beans': 25, 'hot dogs': 24}

# Tastiness rating constraints
m.addConstr(r0['hamburgers'] * hamburgers + r0['black beans'] * black_beans >= 87, name="tastiness_hamburgers_black_beans")
m.addConstr(r0['black beans'] * black_beans + r0['hot dogs'] * hot_dogs >= 30, name="tastiness_black_beans_hot_dogs")
m.addConstr(r0['black beans'] * black_beans + r0['hot dogs'] * hot_dogs <= 190, name="tastiness_black_beans_hot_dogs_max")
m.addConstr(r0['hamburgers'] * hamburgers + r0['black beans'] * black_beans <= 148, name="tastiness_hamburgers_black_beans_max")
m.addConstr(r0['hamburgers'] * hamburgers + r0['black beans'] * black_beans + r0['hot dogs'] * hot_dogs <= 148, name="tastiness_total_max")

# Iron content constraints
m.addConstr(r1['hamburgers'] * hamburgers + r1['black beans'] * black_beans >= 38, name="iron_hamburgers_black_beans")
m.addConstr(r1['black beans'] * black_beans + r1['hot dogs'] * hot_dogs >= 41, name="iron_black_beans_hot_dogs")
m.addConstr(r1['hamburgers'] * hamburgers + r1['hot dogs'] * hot_dogs <= 87, name="iron_hamburgers_hot_dogs_max")
m.addConstr(r1['black beans'] * black_beans + r1['hot dogs'] * hot_dogs <= 72, name="iron_black_beans_hot_dogs_max")
m.addConstr(r1['hamburgers'] * hamburgers + r1['black beans'] * black_beans <= 120, name="iron_hamburgers_black_beans_max")
m.addConstr(r1['hamburgers'] * hamburgers + r1['black beans'] * black_beans + r1['hot dogs'] * hot_dogs <= 120, name="iron_total_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hamburgers: ", hamburgers.varValue)
    print("Black Beans: ", black_beans.varValue)
    print("Hot Dogs: ", hot_dogs.varValue)
else:
    print("The model is infeasible.")
