
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x = m.addVars(6, name="x", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(4*x[0]*x[1] + 3*x[0]*x[5] + 6*x[1]**2 + x[1]*x[4] + 2*x[1]*x[5] + 
               9*x[2]**2 + 9*x[2]*x[5] + 2*x[3]*x[4] + 5*x[3]*x[5] + 9*x[4]**2 + 
               9*x[2] + 5*x[4] + 9*x[5], gp.GRB.MAXIMIZE)

# Constraints
# Sustainability scores
m.addConstr(2*x[0] + 12*x[1] + 2*x[2] + 2*x[3] + 5*x[4] + 9*x[5] <= 305)
# Costs
m.addConstr(8*x[0] + 5*x[1] + 12*x[2] + 7*x[3] + 7*x[4] + 4*x[5] <= 201)

# Additional constraints
m.addConstr(12*x[1] + 2*x[3] >= 41)
m.addConstr(2*x[3] + 5*x[4] >= 37)
m.addConstr(12*x[1]**2 + 2*x[2]**2 + 2*x[3]**2 >= 31)
m.addConstr(5*x[1] + 4*x[5] >= 13)
m.addConstr(8*x[0]**2 + 12*x[2]**2 >= 27)
m.addConstr(8*x[0]**2 + 7*x[3]**2 >= 11)
m.addConstr(12*x[2] + 7*x[3] + 4*x[5] >= 33)
m.addConstr(8*x[0] + 5*x[1] + 12*x[2] >= 33)
m.addConstr(8*x[0] + 7*x[4] + 12*x[2] >= 33)
m.addConstr(12*x[2] + 7*x[3] + 4*x[5] >= 18)
m.addConstr(8*x[0]**2 + 5*x[1]**2 + 12*x[2]**2 >= 18)
m.addConstr(8*x[0] + 12*x[2] + 7*x[4] >= 18)

# Bounds
m.addConstr(2*x[3]**2 + 9*x[5]**2 <= 104)
m.addConstr(2*x[0] + 9*x[5] <= 270)
m.addConstr(4*x[0]**2 + 144*x[1]**2 <= 72)
m.addConstr(144*x[1]**2 + 4*x[3]**2 <= 264)
m.addConstr(2*x[3] + 5*x[4] <= 200)
m.addConstr(4*x[0]**2 + 25*x[4]**2 <= 289)
m.addConstr(12*x[1] + 2*x[2] <= 104)
m.addConstr(144*x[1]**2 + 25*x[4]**2 <= 96)
m.addConstr(2*x[0] + 2*x[3] <= 147)
m.addConstr(2*x[0] + 2*x[3] + 5*x[4] <= 276)
m.addConstr(4*x[0]**2 + 4*x[2]**2 + 4*x[3]**2 <= 147)
m.addConstr(12*x[1] + 2*x[3] + 9*x[5] <= 113)
m.addConstr(2*x[2] + 2*x[3] + 5*x[4] <= 226)
m.addConstr(4*x[3]**2 + 25*x[4]**2 + 81*x[5]**2 <= 83)
m.addConstr(4*x[2]**2 + 25*x[4]**2 + 81*x[5]**2 <= 173)
m.addConstr(4*x[0]**2 + 144*x[1]**2 + 25*x[4]**2 <= 183)
m.addConstr(2*x[0] + 12*x[1] + 9*x[5] <= 228)
m.addConstr(12*x[1] + 2*x[3] + 5*x[4] <= 204)
m.addConstr(4*x[0]**2 + 4*x[2]**2 + 81*x[5]**2 <= 52)
m.addConstr(2*x[0] + 2*x[2] + 5*x[4] <= 156)
m.addConstr(144*x[1]**2 + 4*x[2]**2 + 25*x[4]**2 <= 248)
m.addConstr(12*x[1] + 2*x[2] + 9*x[5] <= 104)
m.addConstr(4*x[2]**2 + 4*x[3]**2 + 81*x[5]**2 <= 214)
m.addConstr(2*x[0] + 5*x[4] + 9*x[5] <= 161)
m.addConstr(4*x[0]**2 + 144*x[1]**2 + 4*x[2]**2 <= 278)
m.addConstr(4*x[0]**2 + 144*x[1]**2 + 4*x[3]**2 <= 90)
m.addConstr(2*x[0] + 12*x[1] + 2*x[2] + 2*x[3] + 5*x[4] + 9*x[5] <= 90)

# Cost constraints
m.addConstr(8*x[0] + 7*x[4] <= 100)
m.addConstr(7*x[4] + 4*x[5] <= 40)
m.addConstr(7*x[3] + 4*x[5] <= 199)
m.addConstr(144*x[2]**2 + 25*x[4]**2 <= 129)
m.addConstr(4*x[2]**2 + 4*x[3]**2 <= 88)
m.addConstr(12*x[2] + 4*x[5] <= 161)
m.addConstr(4*x[3]**2 + 25*x[4]**2 <= 116)
m.addConstr(144*x[1]**2 + 4*x[3]**2 <= 51)
m.addConstr(64*x[0]**2 + 144*x[1]**2 <= 177)
m.addConstr(8*x[0] + 4*x[5] <= 112)
m.addConstr(8*x[0] + 12*x[2] <= 48)
m.addConstr(8*x[0] + 7*x[3] <= 61)
m.addConstr(4*x[2]**2 + 4*x[3]**2 + 25*x[4]**2 <= 59)
m.addConstr(8*x[0] + 5*x[1] + 4*x[5] <= 84)
m.addConstr(64*x[0]**2 + 4*x[3]**2 + 25*x[4]**2 <= 89)
m.addConstr(5*x[1] + 7*x[3] + 4*x[5] <= 73)
m.addConstr(144*x[1]**2 + 4*x[3]**2 + 25*x[4]**2 <= 161)
m.addConstr(64*x[0]**2 + 4*x[2]**2 + 25*x[4]**2 <= 44)
m.addConstr(8*x[0] + 5*x[1] + 12*x[2] + 7*x[3] + 7*x[4] + 4*x[5] <= 44)

# Optimize
m.optimize()

# Print solution
for i in range(6):
    print(f"x[{i}] = {x[i].varValue}")
