
from gurobipy import Model, GRB

# Create a new model
model = Model("calcium_optimization")

# Create variables
green_beans = model.addVar(vtype=GRB.CONTINUOUS, name="green_beans")
hamburgers = model.addVar(vtype=GRB.CONTINUOUS, name="hamburgers")

# Set objective function
model.setObjective(8.4 * green_beans + 6.91 * hamburgers, GRB.MINIMIZE)

# Add constraints
model.addConstr(5 * green_beans + 4 * hamburgers >= 10, "calcium_requirement1")  # Total calcium requirement
model.addConstr(5 * green_beans >= 10, "calcium_requirement2") # Calcium from green beans
model.addConstr(4 * hamburgers >= 10, "calcium_requirement3") # Calcium from hamburgers
model.addConstr(green_beans - hamburgers >= 0, "green_beans_more_than_hamburgers")
model.addConstr(5 * green_beans + 4 * hamburgers <= 21, "calcium_upper_bound") # Upper bound on calcium


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Green beans: {green_beans.x}")
    print(f"Hamburgers: {hamburgers.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

