
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="green_beans")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hamburgers")

# Define the objective function
m.setObjective(8.4*x0 + 6.91*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x0 + 4*x1 >= 10, "calcium_minimum")
m.addConstr(5*x0 + 4*x1 <= 21, "calcium_maximum")
m.addConstr(x0 - x1 >= 0, "green_beans_minus_hamburgers")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Green Beans:", x0.x)
    print("Hamburgers:", x1.x)
    print("Objective Function Value:", m.objVal)
else:
    print("No optimal solution found. Status:", m.status)
