
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    green_beans = model.addVar(name="green_beans", lb=0)  # Assuming non-negative
    hamburgers = model.addVar(name="hamburgers", lb=0)  # Assuming non-negative

    # Objective function: Minimize 8.4 * green beans + 6.91 * hamburgers
    model.setObjective(8.4 * green_beans + 6.91 * hamburgers, gurobi.GRB.MINIMIZE)

    # Constraints
    # Calcium from green beans: 5 * green_beans
    # Calcium from hamburgers: 4 * hamburgers
    # Total calcium at least 10
    model.addConstr(5 * green_beans + 4 * hamburgers >= 10, name="total_calcium_min")

    # Calcium from green beans at least 10
    model.addConstr(5 * green_beans >= 10, name="green_beans_calcium_min")

    # Calcium from hamburgers at least 10
    model.addConstr(4 * hamburgers >= 10, name="hamburgers_calcium_min")

    # Balance constraint: green beans - hamburgers >= 0
    model.addConstr(green_beans - hamburgers >= 0, name="balance_constraint")

    # Total calcium not more than 21
    model.addConstr(5 * green_beans + 4 * hamburgers <= 21, name="total_calcium_max")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Green Beans: {green_beans.varValue}")
        print(f"Hamburgers: {hamburgers.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
