
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
carbs = m.addVar(lb=0, name="carbs")
vitamin_b3 = m.addVar(lb=0, name="vitamin_b3")
iron = m.addVar(lb=0, name="iron")
fat = m.addVar(lb=0, name="fat")
zinc = m.addVar(lb=0, name="zinc")

# Set objective function
m.setObjective(4.23 * carbs + 6.92 * vitamin_b3 + 2.74 * iron + 4.93 * fat + 9.41 * zinc, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11 * carbs + 5 * fat >= 28, "c1")
m.addConstr(5 * vitamin_b3 + 11 * zinc >= 30, "c2")
m.addConstr(1 * iron + 5 * fat >= 44, "c3")
m.addConstr(5 * fat + 11 * zinc >= 32, "c4")
m.addConstr(11 * carbs + 1 * iron >= 26, "c5")
m.addConstr(5 * vitamin_b3 + 5 * fat <= 143, "c6")
m.addConstr(1 * iron + 5 * fat <= 173, "c7")
m.addConstr(5 * vitamin_b3 + 11 * zinc <= 73, "c8")
m.addConstr(5 * fat + 11 * zinc <= 96, "c9")
m.addConstr(11 * carbs + 5 * vitamin_b3 <= 97, "c10")
m.addConstr(11 * carbs + 1 * iron <= 140, "c11")
m.addConstr(1 * iron + 11 * zinc <= 193, "c12")
m.addConstr(11 * carbs + 5 * fat <= 174, "c13")
m.addConstr(11 * carbs + 5 * vitamin_b3 + 5 * fat <= 50, "c14")
m.addConstr(5 * vitamin_b3 + 1 * iron + 11 * zinc <= 200, "c15")
m.addConstr(11 * carbs + 5 * vitamin_b3 + 11 * zinc <= 147, "c16")
m.addConstr(11 * carbs + 5 * vitamin_b3 + 1 * iron <= 180, "c17")
m.addConstr(11 * carbs + 1 * iron + 11 * zinc <= 91, "c18")
m.addConstr(11 * carbs + 5 * fat + 11 * zinc <= 225, "c19")
m.addConstr(11 * carbs + 5 * vitamin_b3 + 1 * iron + 5 * fat + 11 * zinc <= 231, "c20") #Resource constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

