
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(lb=0, name="grams_of_carbohydrates")  # grams of carbohydrates
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B3")  # milligrams of vitamin B3
x2 = m.addVar(lb=0, name="milligrams_of_iron")  # milligrams of iron
x3 = m.addVar(lb=0, name="grams_of_fat")  # grams of fat
x4 = m.addVar(lb=0, name="milligrams_of_zinc")  # milligrams of zinc

# Define the objective function
m.setObjective(4.23*x0 + 6.92*x1 + 2.74*x2 + 4.93*x3 + 9.41*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x0 + 5*x1 + x2 + 5*x3 + 11*x4 <= 231, name="r0_constraint")
m.addConstr(11*x0 + 5*x3 >= 28, name="carbohydrates_fat_constraint")
m.addConstr(5*x1 + 11*x4 >= 30, name="vitamin_B3_zinc_constraint")
m.addConstr(x2 + 5*x3 >= 44, name="iron_fat_constraint")
m.addConstr(5*x3 + 11*x4 >= 32, name="fat_zinc_constraint")
m.addConstr(11*x0 + x2 >= 26, name="carbohydrates_iron_constraint")
m.addConstr(5*x1 + 5*x3 <= 143, name="vitamin_B3_fat_constraint")
m.addConstr(x2 + 5*x3 <= 173, name="iron_fat_constraint_2")
m.addConstr(5*x1 + 11*x4 <= 73, name="vitamin_B3_zinc_constraint_2")
m.addConstr(5*x3 + 11*x4 <= 96, name="fat_zinc_constraint_2")
m.addConstr(11*x0 + 5*x1 <= 97, name="carbohydrates_vitamin_B3_constraint")
m.addConstr(11*x0 + x2 <= 140, name="carbohydrates_iron_constraint_2")
m.addConstr(x2 + 11*x4 <= 193, name="iron_zinc_constraint")
m.addConstr(11*x0 + 5*x3 <= 174, name="carbohydrates_fat_constraint_2")
m.addConstr(11*x0 + 5*x1 + 5*x3 <= 50, name="carbohydrates_vitamin_B3_fat_constraint")
m.addConstr(5*x1 + x2 + 11*x4 <= 200, name="vitamin_B3_iron_zinc_constraint")
m.addConstr(11*x0 + 5*x1 + 11*x4 <= 147, name="carbohydrates_vitamin_B3_zinc_constraint")
m.addConstr(11*x0 + 5*x1 + x2 <= 180, name="carbohydrates_vitamin_B3_iron_constraint")
m.addConstr(11*x0 + x2 + 11*x4 <= 91, name="carbohydrates_iron_zinc_constraint")
m.addConstr(11*x0 + 5*x3 + 11*x4 <= 225, name="carbohydrates_fat_zinc_constraint")
m.addConstr(11*x0 + 5*x1 + x2 + 5*x3 + 11*x4 <= 225, name="all_variables_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Grams of carbohydrates: ", x0.varValue)
    print("Milligrams of vitamin B3: ", x1.varValue)
    print("Milligrams of iron: ", x2.varValue)
    print("Grams of fat: ", x3.varValue)
    print("Milligrams of zinc: ", x4.varValue)
else:
    print("The model is infeasible")
