
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
automatic_alerts = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")
patches_per_day = m.addVar(vtype=gp.GRB.INTEGER, name="patches_per_day")
pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")

# Set objective function
m.setObjective(1 * automatic_alerts + 4 * patches_per_day + 2 * pen_testers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(21 * automatic_alerts + 20 * patches_per_day + 1 * pen_testers <= 134, "c0_computational_load") # Resource Constraint
m.addConstr(26 * automatic_alerts + 9 * patches_per_day + 9 * pen_testers <= 168, "c1_data_confidentiality") # Resource Constraint
m.addConstr(24 * automatic_alerts + 24 * patches_per_day + 5 * pen_testers <= 187, "c2_data_integrity") # Resource Constraint
m.addConstr(26 * automatic_alerts + 19 * patches_per_day + 2 * pen_testers <= 146, "c3_data_accessibility") # Resource Constraint
m.addConstr(1 * automatic_alerts + 5 * patches_per_day + 10 * pen_testers <= 133, "c4_dollar_cost") # Resource Constraint

m.addConstr(26 * automatic_alerts + 2 * pen_testers >= 16, "c5")
m.addConstr(19 * patches_per_day + 2 * pen_testers >= 39, "c6")
m.addConstr(1 * automatic_alerts + 5 * patches_per_day + 10 * pen_testers >= 36, "c7")
m.addConstr(21 * automatic_alerts + 20 * patches_per_day <= 48, "c8")
m.addConstr(21 * automatic_alerts + 1 * pen_testers <= 88, "c9")
m.addConstr(20 * patches_per_day + 1 * pen_testers <= 112, "c10")
m.addConstr(21 * automatic_alerts + 20 * patches_per_day + 1 * pen_testers <= 112, "c11")
m.addConstr(26 * automatic_alerts + 9 * pen_testers <= 102, "c12")
m.addConstr(9 * patches_per_day + 9 * pen_testers <= 117, "c13")
m.addConstr(26 * automatic_alerts + 9 * patches_per_day + 9 * pen_testers <= 117, "c14")
m.addConstr(24 * automatic_alerts + 5 * pen_testers <= 178, "c15")
m.addConstr(24 * automatic_alerts + 24 * patches_per_day <= 62, "c16")
m.addConstr(24 * automatic_alerts + 24 * patches_per_day + 5 * pen_testers <= 143, "c17")
m.addConstr(24 * automatic_alerts + 24 * patches_per_day + 5 * pen_testers <= 143, "c18") # Duplicate constraint
m.addConstr(26 * automatic_alerts + 19 * patches_per_day <= 52, "c19")
m.addConstr(19 * patches_per_day + 2 * pen_testers <= 139, "c20")
m.addConstr(26 * automatic_alerts + 19 * patches_per_day + 2 * pen_testers <= 139, "c21")
m.addConstr(1 * automatic_alerts + 10 * pen_testers <= 103, "c22")
m.addConstr(5 * patches_per_day + 10 * pen_testers <= 129, "c23")
m.addConstr(1 * automatic_alerts + 5 * patches_per_day + 10 * pen_testers <= 129, "c24")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('automatic_alerts:', automatic_alerts.x)
    print('patches_per_day:', patches_per_day.x)
    print('pen_testers:', pen_testers.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
