
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
ramen = m.addVar(lb=0, name="ramen")
apple_pie = m.addVar(lb=0, name="apple_pie")
cheeseburger = m.addVar(lb=0, name="cheeseburger")
cherry_pie = m.addVar(lb=0, name="cherry_pie")
ham_sandwich = m.addVar(lb=0, name="ham_sandwich")

# Set objective function
m.setObjective(6 * ramen + 7 * apple_pie + 5 * cheeseburger + 5 * cherry_pie + 6 * ham_sandwich, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.72 * apple_pie + 1.61 * ham_sandwich >= 15, "iron_constraint1")
m.addConstr(11.31 * ramen + 12.33 * cheeseburger >= 18, "iron_constraint2")
m.addConstr(12.33 * cheeseburger + 1.61 * ham_sandwich >= 33, "iron_constraint3")
m.addConstr(12.33 * cheeseburger + 11.32 * cherry_pie >= 14, "iron_constraint4")
m.addConstr(12.33 * cheeseburger + 11.32 * cherry_pie + 1.61 * ham_sandwich >= 21, "iron_constraint5")
m.addConstr(11.31 * ramen + 12.33 * cheeseburger + 1.61 * ham_sandwich >= 21, "iron_constraint6")
m.addConstr(12.33 * cheeseburger + 11.32 * cherry_pie + 1.61 * ham_sandwich >= 23, "iron_constraint7")
m.addConstr(11.31 * ramen + 12.33 * cheeseburger + 1.61 * ham_sandwich >= 23, "iron_constraint8")
m.addConstr(11.31 * ramen + 0.72 * apple_pie + 12.33 * cheeseburger + 11.32 * cherry_pie + 1.61 * ham_sandwich >= 23, "iron_constraint9")
m.addConstr(11.31 * ramen + 0.72 * apple_pie <= 57, "iron_constraint10")
m.addConstr(11.31 * ramen + 0.72 * apple_pie + 11.32 * cherry_pie <= 87, "iron_constraint11")
m.addConstr(11.31 * ramen + 12.33 * cheeseburger + 1.61 * ham_sandwich <= 163, "iron_constraint12")
m.addConstr(11.31 * ramen + 0.72 * apple_pie + 12.33 * cheeseburger <= 126, "iron_constraint13")
m.addConstr(11.31 * ramen + 11.32 * cherry_pie + 1.61 * ham_sandwich <= 70, "iron_constraint14")
m.addConstr(0.72 * apple_pie + 12.33 * cheeseburger + 1.61 * ham_sandwich <= 92, "iron_constraint15")
m.addConstr(11.31 * ramen + 0.72 * apple_pie + 1.61 * ham_sandwich <= 147, "iron_constraint16")
m.addConstr(11.31 * ramen + 0.72 * apple_pie + 12.33 * cheeseburger + 11.32 * cherry_pie + 1.61 * ham_sandwich <= 185, "iron_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

