
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="bowls_of_instant_ramen")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="apple_pies")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="cheeseburgers")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="cherry_pies")
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, name="ham_sandwiches")
    
    # Objective function
    model.setObjective(6*x0 + 7*x1 + 5*x2 + 5*x3 + 6*x4, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(0.72*x1 + 1.61*x4 >= 15)
    model.addConstr(11.31*x0 + 12.33*x2 >= 18)
    model.addConstr(12.33*x2 + 1.61*x4 >= 33)
    model.addConstr(12.33*x2 + 11.32*x3 >= 14)
    model.addConstr(12.33*x2 + 11.32*x3 + 1.61*x4 >= 21)
    model.addConstr(11.31*x0 + 12.33*x2 + 1.61*x4 >= 21)
    model.addConstr(12.33*x2 + 11.32*x3 + 1.61*x4 >= 23)
    model.addConstr(11.31*x0 + 12.33*x2 + 1.61*x4 >= 23)
    model.addConstr(11.31*x0 + 0.72*x1 + 12.33*x2 + 11.32*x3 + 1.61*x4 >= 23)
    model.addConstr(11.31*x0 + 0.72*x1 <= 57)
    model.addConstr(11.31*x0 + 0.72*x1 + 11.32*x3 <= 87)
    model.addConstr(11.31*x0 + 12.33*x2 + 1.61*x4 <= 163)
    model.addConstr(11.31*x0 + 0.72*x1 + 12.33*x2 <= 126)
    model.addConstr(11.31*x0 + 11.32*x3 + 1.61*x4 <= 70)
    model.addConstr(0.72*x1 + 12.33*x2 + 1.61*x4 <= 92)
    model.addConstr(11.31*x0 + 0.72*x1 + 1.61*x4 <= 147)
    
    # Resource constraint
    model.addConstr(11.31*x0 + 0.72*x1 + 12.33*x2 + 11.32*x3 + 1.61*x4 <= 185)
    
    # Solve the problem
    model.optimize()
    
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("bowls_of_instant_ramen: ", x0.varValue)
        print("apple_pies: ", x1.varValue)
        print("cheeseburgers: ", x2.varValue)
        print("cherry_pies: ", x3.varValue)
        print("ham_sandwiches: ", x4.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
