
from gurobipy import Model, GRB

# Create a new model
m = Model("PlantOptimization")

# Create variables
cherry_trees = m.addVar(vtype=GRB.INTEGER, name="cherry_trees")
sunflowers = m.addVar(vtype=GRB.INTEGER, name="sunflowers")

# Set objective function
m.setObjective(6.23 * cherry_trees + 4.36 * sunflowers, GRB.MINIMIZE)

# Add constraints
m.addConstr(19 * cherry_trees + 9 * sunflowers >= 88, "min_water_need")  # Combined minimum water need
m.addConstr(19 * cherry_trees + 9 * sunflowers <= 221, "max_water_need") # Combined maximum water need
m.addConstr(18 * cherry_trees + 30 * sunflowers >= 59, "min_planting_space") # Combined minimum planting space
m.addConstr(18 * cherry_trees + 30 * sunflowers <= 62, "max_planting_space") # Combined maximum planting space
m.addConstr(8 * cherry_trees + 32 * sunflowers >= 24, "min_beauty_rating") # Combined minimum beauty rating
m.addConstr(8 * cherry_trees + 32 * sunflowers <= 39, "max_beauty_rating") # Combined maximum beauty rating
m.addConstr(5 * cherry_trees + 27 * sunflowers >= 98, "min_growth_speed") # Combined minimum growth speed
m.addConstr(5 * cherry_trees + 27 * sunflowers <= 289, "max_growth_speed") # Combined maximum growth speed
m.addConstr(25 * cherry_trees + 1 * sunflowers >= 32, "min_yield") # Combined minimum yield
m.addConstr(25 * cherry_trees + 1 * sunflowers <= 161, "max_yield") # Combined maximum yield
m.addConstr(7 * cherry_trees - 3 * sunflowers >= 0, "cherry_sunflower_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Cherry Trees: %g' % cherry_trees.x)
    print('Sunflowers: %g' % sunflowers.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

