
import gurobi as gp

# Define the model
model = gp.Model("optimization_problem")

# Define the variables
x0 = model.addVar(name="cherry_trees", vtype=gp.GRB.INTEGER)
x1 = model.addVar(name="sunflowers", vtype=gp.GRB.INTEGER)

# Define the objective function
model.setObjective(6.23*x0 + 4.36*x1, gp.GRB.MINIMIZE)

# Define the constraints
model.addConstr(19*x0 + 9*x1 >= 88, name="water_need")
model.addConstr(18*x0 + 30*x1 >= 59*144, name="planting_space")
model.addConstr(8*x0 + 32*x1 >= 24, name="beauty_rating")
model.addConstr(5*x0 + 27*x1 >= 98, name="growth_speed")
model.addConstr(25*x0 + x1 >= 32, name="yield")
model.addConstr(7*x0 - 3*x1 >= 0, name="cherry_sunflower_ratio")
model.addConstr(19*x0 + 9*x1 <= 221, name="water_need_upper")
model.addConstr(18*x0 + 30*x1 <= 62*144, name="planting_space_upper")
model.addConstr(8*x0 + 32*x1 <= 39, name="beauty_rating_upper")
model.addConstr(5*x0 + 27*x1 <= 289, name="growth_speed_upper")
model.addConstr(25*x0 + x1 <= 161, name="yield_upper")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Cherry trees: {x0.varValue}")
    print(f"Sunflowers: {x1.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
