
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
honeypots = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")

# Set objective function
m.setObjective(5.1 * pen_testers + 3.94 * honeypots, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16 * pen_testers + 13 * honeypots >= 69, "computational_load_min")
m.addConstr(2 * pen_testers + 16 * honeypots >= 15, "data_confidentiality_min")
m.addConstr(-8 * pen_testers + 10 * honeypots >= 0, "custom_constraint")
m.addConstr(16 * pen_testers + 13 * honeypots <= 127, "computational_load_max")
m.addConstr(2 * pen_testers + 16 * honeypots <= 65, "data_confidentiality_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Pen Testers: {pen_testers.x}")
    print(f"  Honeypots: {honeypots.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {m.status}")

