
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
pen_testers = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
honeypots = m.addVar(vtype=GRB.INTEGER, name="honeypots")

# Objective function
m.setObjective(5.1 * pen_testers + 3.94 * honeypots, GRB.MINIMIZE)

# Constraints
m.addConstr(16 * pen_testers + 13 * honeypots >= 69, "Computational_Load_Min")
m.addConstr(2 * pen_testers + 16 * honeypots >= 15, "Data_Confidentiality_Min")
m.addConstr(-8 * pen_testers + 10 * honeypots >= 0, "Pen_Testers_Honeypots_Balance")
m.addConstr(16 * pen_testers + 13 * honeypots <= 127, "Computational_Load_Max")
m.addConstr(2 * pen_testers + 16 * honeypots <= 65, "Data_Confidentiality_Max")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Pen Testers: {pen_testers.x}")
    print(f"Honeypots: {honeypots.x}")
else:
    print("No optimal solution found.")
