
import gurobipy as gp

# Create a new model
m = gp.Model("Optimization_Problem")

# Define the variables
pen_testers = m.addVar(name="pen_testers", vtype=gp.GRB.INTEGER)
honeypots = m.addVar(name="honeypots", vtype=gp.GRB.INTEGER)

# Objective function: Minimize 5.1 * pen_testers + 3.94 * honeypots
m.setObjective(5.1 * pen_testers + 3.94 * honeypots, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(16 * pen_testers + 13 * honeypots >= 69, name="computational_load_min")
m.addConstr(2 * pen_testers + 16 * honeypots >= 15, name="data_confidentiality_impact_min")
m.addConstr(-8 * pen_testers + 10 * honeypots >= 0, name="pen_testers_vs_honeypots")
m.addConstr(16 * pen_testers + 13 * honeypots <= 127, name="computational_load_max")  # Using 127 as per the problem
m.addConstr(2 * pen_testers + 16 * honeypots <= 65, name="data_confidentiality_impact_max")

# Solve the model
m.solve()

# Output the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"pen testers: {pen_testers.varValue}")
    print(f"honeypots: {honeypots.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
