
from gurobipy import *

# Create a model
m = Model("Nutrition_Problem")

# Define variables
F = m.addVar(vtype=GRB.INTEGER, name="fruit_salads")
R = m.addVar(vtype=GRB.INTEGER, name="rotisserie_chickens")
S = m.addVar(vtype=GRB.CONTINUOUS, name="strawberries")
C = m.addVar(vtype=GRB.CONTINUOUS, name="cheeseburgers")
B = m.addVar(vtype=GRB.INTEGER, name="bananas")
P = m.addVar(vtype=GRB.INTEGER, name="slices_of_pizza")
BP = m.addVar(vtype=GRB.INTEGER, name="blueberry_pies")

# Objective function (assuming we want to maximize iron intake)
m.setObjective(0, GRB.MAXIMIZE)  # Placeholder objective; adjust based on actual requirements

# Constraints
# Carbohydrates constraints
m.addConstr(F + R + S + C + B + P + BP >= 30, "min_carb")
m.addConstr(F + R + S + C + B + P + BP <= 400, "max_carb")

# Iron constraints (example; actual values depend on specific iron content of each food)
m.addConstr(10*R + 5*S + 2*C + 1*B + 3*P + 4*BP <= 495, "max_iron")
m.addConstr(2*B + 3*P + 1*BP <= 539, "max_iron_bp")

# Other constraints
m.addConstr(R >= 0, "rotisserie_chickens_non_negative")
m.addConstr(F >= 0, "fruit_salads_non_negative")
m.addConstr(B >= 0, "bananas_non_negative")
m.addConstr(P >= 0, "pizza_non_negative")
m.addConstr(BP >= 0, "blueberry_pies_non_negative")

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
