
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    mary_hours = m.addVar(lb=0, name="mary_hours")  # Non-negative hours
    laura_hours = m.addVar(lb=0, name="laura_hours") # Non-negative hours

    # Set objective function
    m.setObjective(4 * mary_hours**2 + 7 * mary_hours, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2 * mary_hours + 20 * laura_hours >= 35, "dollar_cost_min")
    m.addConstr(4 * mary_hours + 11 * laura_hours >= 78, "computer_competence_min")
    m.addConstr(5 * mary_hours + 5 * laura_hours >= 50, "productivity_min")
    m.addConstr(7 * mary_hours + 18 * laura_hours >= 31, "paperwork_competence_min")
    m.addConstr(11 * mary_hours + 1 * laura_hours >= 38, "work_quality_min")
    m.addConstr(2 * mary_hours - 3 * laura_hours >= 0, "custom_constraint_1")

    m.addConstr(2 * mary_hours**2 + 20 * laura_hours**2 <= 45, "dollar_cost_max") # Note: Quadratic Constraint
    m.addConstr(4 * mary_hours + 11 * laura_hours <= 122, "computer_competence_max")
    m.addConstr(5 * mary_hours + 5 * laura_hours <= 116, "productivity_max")
    m.addConstr(7 * mary_hours**2 + 18 * laura_hours**2 <= 95, "paperwork_competence_max") # Note: Quadratic Constraint
    m.addConstr(11 * mary_hours + 1 * laura_hours <= 77, "work_quality_max")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Mary Hours: %g' % mary_hours.x)
        print('Laura Hours: %g' % laura_hours.x)
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
