
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="hours_worked_by_Mary")
x1 = m.addVar(lb=0, name="hours_worked_by_Laura")

# Objective function: Minimize 4*x0^2 + 7*x0
m.setObjective(4*x0**2 + 7*x0, GRB.MINIMIZE)

# Constraints
m.addConstr(2*x0 + 20*x1 >= 35, name="dollar_cost_constraint")
m.addConstr(4*x0 + 11*x1 >= 78, name="computer_competence_rating_constraint")
m.addConstr(5*x0 + 5*x1 >= 50, name="productivity_rating_constraint")
m.addConstr(7*x0 + 18*x1 >= 31, name="paperwork_competence_rating_constraint")
m.addConstr(11*x0 + x1 >= 38, name="work_quality_rating_constraint")
m.addConstr(2*x0 - 3*x1 >= 0, name="linear_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Mary: {x0.x}")
    print(f"Hours worked by Laura: {x1.x}")
else:
    print("No optimal solution found.")
