
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
hours_worked_by_Mary = m.addVar(name="hours_worked_by_Mary", lb=0)
hours_worked_by_Laura = m.addVar(name="hours_worked_by_Laura", lb=0)

# Define the objective function
m.setObjective(4 * hours_worked_by_Mary**2 + 7 * hours_worked_by_Mary, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * hours_worked_by_Mary + 20 * hours_worked_by_Laura >= 35)
m.addConstr(4 * hours_worked_by_Mary + 11 * hours_worked_by_Laura >= 78)
m.addConstr(5 * hours_worked_by_Mary + 5 * hours_worked_by_Laura >= 50)
m.addConstr(7 * hours_worked_by_Mary + 18 * hours_worked_by_Laura >= 31)
m.addConstr(11 * hours_worked_by_Mary + hours_worked_by_Laura >= 38)
m.addConstr(2 * hours_worked_by_Mary - 3 * hours_worked_by_Laura >= 0)

m.addConstr(2**2 * hours_worked_by_Mary**2 + 20**2 * hours_worked_by_Laura**2 <= 45)
m.addConstr(4 * hours_worked_by_Mary + 11 * hours_worked_by_Laura <= 122)
m.addConstr(5 * hours_worked_by_Mary + 5 * hours_worked_by_Laura <= 116)
m.addConstr(7**2 * hours_worked_by_Mary**2 + 18**2 * hours_worked_by_Laura**2 <= 95)
m.addConstr(11 * hours_worked_by_Mary + hours_worked_by_Laura <= 77)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Mary: {hours_worked_by_Mary.varValue}")
    print(f"Hours worked by Laura: {hours_worked_by_Laura.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
