
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
protein = m.addVar(vtype=gp.GRB.INTEGER, name="protein")  # Integer grams of protein
vitamin_d = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_d") # milligrams of vitamin D

# Set objective function
m.setObjective(7 * protein + 3 * vitamin_d, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(15 * protein + 14 * vitamin_d >= 33, "kidney_support_min")
m.addConstr(5 * protein + 25 * vitamin_d >= 78, "cardiovascular_support_min")
m.addConstr(9 * protein - 6 * vitamin_d >= 0, "protein_vitamin_d_ratio")
m.addConstr(15 * protein + 14 * vitamin_d <= 75, "kidney_support_max")
m.addConstr(5 * protein + 25 * vitamin_d <= 189, "cardiovascular_support_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Grams of protein: {protein.x}")
    print(f"  Milligrams of vitamin D: {vitamin_d.x}")
    print(f"  Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

