
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="grams_of_protein")  # Integer variable for grams of protein
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_D")  # Continuous variable for milligrams of vitamin D

# Objective function: Minimize 7*x0 + 3*x1
m.setObjective(7*x0 + 3*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(15*x0 + 14*x1 >= 33, name="kidney_support_index_min")  # Total kidney support index minimum
m.addConstr(5*x0 + 25*x1 >= 78, name="cardiovascular_support_index_min")  # Total cardiovascular support index minimum
m.addConstr(9*x0 - 6*x1 >= 0, name="additional_constraint")  # Additional constraint
m.addConstr(15*x0 + 14*x1 <= 75, name="kidney_support_index_max")  # Total kidney support index maximum
m.addConstr(5*x0 + 25*x1 <= 189, name="cardiovascular_support_index_max")  # Total cardiovascular support index maximum

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of Protein: {x0.x}")
    print(f"Milligrams of Vitamin D: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
