
import gurobipy as gp

# Create a new model
m = gp.Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name="grams_of_protein", vtype=gp.GRB.INTEGER)  # Integer variable
x1 = m.addVar(name="milligrams_of_vitamin_D")  # Continuous variable

# Objective function: minimize 7 * x0 + 3 * x1
m.setObjective(7 * x0 + 3 * x1, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(15 * x0 + 14 * x1 >= 33, name="kidney_support_min")
m.addConstr(5 * x0 + 25 * x1 >= 78, name="cardiovascular_support_min")
m.addConstr(9 * x0 - 6 * x1 >= 0, name="protein_vitamin_balance")
m.addConstr(15 * x0 + 14 * x1 <= 75, name="kidney_support_max")
m.addConstr(5 * x0 + 25 * x1 <= 189, name="cardiovascular_support_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Grams of protein: {x0.varValue}")
    print(f"Milligrams of vitamin D: {x1.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
