
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
paper_plates = model.addVar(vtype=GRB.INTEGER, name="paper_plates")
lightbulbs = model.addVar(vtype=GRB.INTEGER, name="lightbulbs")
cookies = model.addVar(vtype=GRB.INTEGER, name="cookies")
napkins = model.addVar(vtype=GRB.INTEGER, name="napkins")
milk = model.addVar(vtype=GRB.INTEGER, name="milk")

# Set objective function
model.setObjective(7 * paper_plates + 8 * lightbulbs + 5 * cookies + 1 * napkins + 9 * milk, GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.47 * paper_plates + 0.26 * lightbulbs + 0.83 * milk >= 8)
model.addConstr(8 * lightbulbs - 2 * cookies + 10 * milk >= 0)
model.addConstr(0.26 * lightbulbs + 0.78 * napkins <= 63)
model.addConstr(0.47 * paper_plates + 0.29 * cookies <= 41)
model.addConstr(0.29 * cookies + 0.83 * milk <= 15)
model.addConstr(0.47 * paper_plates + 0.78 * napkins <= 34)
model.addConstr(0.47 * paper_plates + 0.83 * milk <= 74)
model.addConstr(0.26 * lightbulbs + 0.83 * milk <= 69)
model.addConstr(0.26 * lightbulbs + 0.29 * cookies <= 30)
model.addConstr(0.47 * paper_plates + 0.26 * lightbulbs + 0.78 * napkins <= 70)
model.addConstr(0.29 * cookies + 0.78 * napkins + 0.83 * milk <= 56)
model.addConstr(0.47 * paper_plates + 0.26 * lightbulbs + 0.83 * milk <= 41)
model.addConstr(0.47 * paper_plates + 0.26 * lightbulbs + 0.29 * cookies <= 48)
model.addConstr(0.26 * lightbulbs + 0.78 * napkins + 0.83 * milk <= 70)
model.addConstr(0.26 * lightbulbs + 0.29 * cookies + 0.83 * milk <= 51)
model.addConstr(0.26 * lightbulbs + 0.29 * cookies + 0.78 * napkins <= 61)
model.addConstr(0.47 * paper_plates + 0.26 * lightbulbs + 0.29 * cookies + 0.78 * napkins + 0.83 * milk <= 61)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"  Paper Plates: {paper_plates.x}")
    print(f"  Lightbulbs: {lightbulbs.x}")
    print(f"  Cookies: {cookies.x}")
    print(f"  Napkins: {napkins.x}")
    print(f"  Milk: {milk.x}")
    print(f"  Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

