
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="packs_of_paper_plates", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="lightbulbs", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="cookies", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="packs_of_napkins", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="cartons_of_milk", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7 * x0 + 8 * x1 + 5 * x2 + x3 + 9 * x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(0.47 * x0 + 0.26 * x1 + 0.83 * x4 >= 8)
    model.addConstr(8 * x1 - 2 * x2 + 10 * x4 >= 0)
    model.addConstr(0.26 * x1 + 0.78 * x3 <= 63)
    model.addConstr(0.47 * x0 + 0.29 * x2 <= 41)
    model.addConstr(0.29 * x2 + 0.83 * x4 <= 15)
    model.addConstr(0.47 * x0 + 0.78 * x3 <= 34)
    model.addConstr(0.47 * x0 + 0.83 * x4 <= 74)
    model.addConstr(0.26 * x1 + 0.83 * x4 <= 69)
    model.addConstr(0.26 * x1 + 0.29 * x2 <= 30)
    model.addConstr(0.47 * x0 + 0.26 * x1 + 0.78 * x3 <= 70)
    model.addConstr(0.29 * x2 + 0.78 * x3 + 0.83 * x4 <= 56)
    model.addConstr(0.47 * x0 + 0.26 * x1 + 0.83 * x4 <= 41)
    model.addConstr(0.47 * x0 + 0.26 * x1 + 0.29 * x2 <= 48)
    model.addConstr(0.26 * x1 + 0.78 * x3 + 0.83 * x4 <= 70)
    model.addConstr(0.26 * x1 + 0.29 * x2 + 0.83 * x4 <= 51)
    model.addConstr(0.26 * x1 + 0.29 * x2 + 0.78 * x3 <= 61)
    model.addConstr(0.47 * x0 + 0.26 * x1 + 0.29 * x2 + 0.78 * x3 + 0.83 * x4 <= 61)

    # Set bounds for variables (not strictly necessary for integers but good practice)
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)
    model.addConstr(x3 >= 0)
    model.addConstr(x4 >= 0)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("packs of paper plates: ", x0.varValue)
        print("lightbulbs: ", x1.varValue)
        print("cookies: ", x2.varValue)
        print("packs of napkins: ", x3.varValue)
        print("cartons of milk: ", x4.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
