
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Staffing Cost")

# Create variables
paul = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Paul")
bill = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bill")
ringo = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Ringo")
jean = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Jean")
mary = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Mary")

# Set objective function
model.setObjective(5*paul + 3*bill + 1*ringo + 1*jean + 6*mary, GRB.MINIMIZE)

# Add constraints

# Resource Constraints
model.addConstr(17*paul + 13*bill + 20*ringo + 11*jean + 23*mary <= 182, "r0_paperwork_competence")
model.addConstr(15*paul + 12*bill + 19*ringo + 9*jean + 22*mary <= 419, "r1_dollar_cost_per_hour")
model.addConstr(18*paul + 2*bill + 4*ringo + 5*jean + 16*mary <= 227, "r2_likelihood_to_quit")
model.addConstr(28*paul + 8*bill + 26*ringo + 27*jean + 4*mary <= 442, "r3_productivity_rating")


# Specific Constraints
model.addConstr(11*jean + 23*mary >= 33, "c1")
model.addConstr(17*paul + 23*mary >= 20, "c2")
model.addConstr(13*bill + 11*jean >= 23, "c3")
model.addConstr(17*paul + 13*bill + 20*ringo + 11*jean + 23*mary >= 23, "c4")
model.addConstr(15*paul + 19*ringo >= 60, "c5")
model.addConstr(9*jean + 22*mary >= 57, "c6")
model.addConstr(12*bill + 9*jean >= 58, "c7")
model.addConstr(19*ringo + 9*jean >= 66, "c8")
model.addConstr(15*paul + 12*bill >= 34, "c9")
model.addConstr(12*bill + 19*ringo + 9*jean >= 45, "c10")
model.addConstr(12*bill + 19*ringo + 22*mary >= 45, "c11")
model.addConstr(15*paul + 19*ringo + 22*mary >= 45, "c12")
model.addConstr(12*bill + 19*ringo + 9*jean >= 58, "c13")
model.addConstr(12*bill + 19*ringo + 22*mary >= 58, "c14")
model.addConstr(15*paul + 19*ringo + 22*mary >= 58, "c15")
model.addConstr(12*bill + 19*ringo + 9*jean >= 53, "c16")
model.addConstr(12*bill + 19*ringo + 22*mary >= 53, "c17")
model.addConstr(15*paul + 19*ringo + 22*mary >= 53, "c18")
model.addConstr(15*paul + 12*bill + 19*ringo + 9*jean + 22*mary >= 53, "c19")
model.addConstr(4*ringo + 5*jean >= 25, "c20")
model.addConstr(18*paul + 4*ringo >= 41, "c21")
model.addConstr(2*bill + 4*ringo >= 44, "c22")
model.addConstr(5*jean + 16*mary >= 25, "c23")
model.addConstr(18*paul + 2*bill >= 20, "c24")
model.addConstr(18*paul + 16*mary >= 26, "c25")
model.addConstr(18*paul + 2*bill + 4*ringo + 5*jean + 16*mary >= 26, "c26")
model.addConstr(28*paul + 27*jean >= 48, "c27")
model.addConstr(8*bill + 4*mary >= 35, "c28")
model.addConstr(28*paul + 4*mary >= 87, "c29")
model.addConstr(28*paul + 8*bill >= 66, "c30")
model.addConstr(8*bill + 27*jean >= 39, "c31")
model.addConstr(26*ringo + 27*jean >= 64, "c32")
model.addConstr(8*bill + 26*ringo >= 61, "c33")
model.addConstr(26*ringo + 27*jean + 4*mary >= 79, "c34")
model.addConstr(28*paul + 8*bill + 4*mary >= 79, "c35")
model.addConstr(8*bill + 26*ringo + 27*jean >= 79, "c36")
model.addConstr(8*bill + 26*ringo + 4*mary >= 79, "c37")
model.addConstr(28*paul + 27*jean + 4*mary >= 79, "c38")
model.addConstr(26*ringo + 27*jean + 4*mary >= 85, "c39")
model.addConstr(28*paul + 8*bill + 4*mary >= 85, "c40")
model.addConstr(8*bill + 26*ringo + 27*jean >= 85, "c41")
model.addConstr(8*bill + 26*ringo + 4*mary >= 85, "c42")
model.addConstr(28*paul + 27*jean + 4*mary >= 85, "c43")
model.addConstr(26*ringo + 27*jean + 4*mary >= 81, "c44")
model.addConstr(28*paul + 8*bill + 4*mary >= 81, "c45")
model.addConstr(8*bill + 26*ringo + 27*jean >= 81, "c46")
model.addConstr(8*bill + 26*ringo + 4*mary >= 81, "c47")
model.addConstr(28*paul + 27*jean + 4*mary >= 81, "c48")
model.addConstr(26*ringo + 27*jean + 4*mary >= 57, "c49")
model.addConstr(28*paul + 8*bill + 4*mary >= 57, "c50")
model.addConstr(8*bill + 26*ringo + 27*jean >= 57, "c51")
model.addConstr(8*bill + 26*ringo + 4*mary >= 57, "c52")
model.addConstr(28*paul + 27*jean + 4*mary >= 57, "c53")
model.addConstr(26*ringo + 27*jean + 4*mary >= 70, "c54")
model.addConstr(28*paul + 8*bill + 4*mary >= 70, "c55")
model.addConstr(8*bill + 26*ringo + 27*jean >= 70, "c56")
model.addConstr(8*bill + 26*ringo + 4*mary >= 70, "c57")
model.addConstr(28*paul + 27*jean + 4*mary >= 70, "c58")
model.addConstr(28*paul + 8*bill + 26*ringo + 27*jean + 4*mary >= 70, "c59")
model.addConstr(10*jean - 7*mary >= 0, "c60")
model.addConstr(17*paul + 13*bill + 11*jean <= 172, "c61")
model.addConstr(13*bill + 11*jean + 23*mary <= 86, "c62")
model.addConstr(17*paul + 13*bill + 20*ringo <= 48, "c63")
model.addConstr(17*paul + 11*jean + 23*mary <= 137, "c64")
model.addConstr(13*bill + 20*ringo + 11*jean <= 158, "c65")
model.addConstr(17*paul + 20*ringo + 11*jean <= 56, "c66")
model.addConstr(13*bill + 20*ringo + 23*mary <= 103, "c67")
model.addConstr(12*bill + 9*jean <= 201, "c68")
model.addConstr(18*paul + 2*bill + 4*ringo <= 75, "c69")
model.addConstr(18*paul + 5*jean + 16*mary <= 223, "c70")
model.addConstr(18*paul + 2*bill + 5*jean <= 218, "c71")
model.addConstr(18*paul + 4*ringo + 5*jean <= 113, "c72")
model.addConstr(8*bill + 4*mary <= 425, "c73")
model.addConstr(26*ringo + 27*jean <= 255, "c74")
model.addConstr(28*paul + 8*bill + 27*jean <= 195, "c75")
model.addConstr(8*bill + 26*ringo + 4*mary <= 397, "c76")
model.addConstr(8*bill + 27*jean + 4*mary <= 359, "c77")
model.addConstr(8*bill + 26*ringo + 27*jean <= 246, "c78")
model.addConstr(28*paul + 27*jean + 4*mary <= 182, "c79")
model.addConstr(28*paul + 26*ringo + 4*mary <= 174, "c80")
model.addConstr(28*paul + 8*bill + 26*ringo <= 249, "c81")
model.addConstr(26*ringo + 27*jean + 4*mary <= 238, "c82")
model.addConstr(28*paul + 8*bill + 4*mary <= 377, "c83")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {model.status}")
