
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
calcium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="calcium")
vitamin_e = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_e")

# Set objective function
model.setObjective(5.76 * calcium + 4.41 * vitamin_e, GRB.MINIMIZE)

# Add constraints
model.addConstr(20 * calcium + 13 * vitamin_e >= 48, "immune_support_min")
model.addConstr(20 * calcium + 13 * vitamin_e <= 129, "immune_support_max")
model.addConstr(-9 * calcium + 10 * vitamin_e >= 0, "calcium_vitamin_e_ratio")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal calcium: {calcium.x}")
    print(f"Optimal vitamin E: {vitamin_e.x}")
    print(f"Optimal objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

