
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name="milligrams_of_calcium", lb=0)  # Lower bound set to 0, assuming non-negativity
x1 = m.addVar(name="milligrams_of_vitamin_E", lb=0)  # Lower bound set to 0, assuming non-negativity

# Set the objective function
m.setObjective(5.76*x0 + 4.41*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x0 + 13*x1 >= 48, name="immune_support_index_min")
m.addConstr(-9*x0 + 10*x1 >= 0, name="expression_constraint")
m.addConstr(20*x0 + 13*x1 <= 129, name="immune_support_index_max")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of calcium: {x0.x}")
    print(f"Milligrams of vitamin E: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
