
import gurobipy as gp

# Create a new model
m = gp.Model("Optimization_Problem")

# Define variables
calcium = m.addVar(name="calcium", lb=0)  # Assuming non-negative
vitamin_E = m.addVar(name="vitamin_E", lb=0)  # Assuming non-negative

# Objective function
m.setObjective(5.76 * calcium + 4.41 * vitamin_E, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(20 * calcium + 13 * vitamin_E >= 48, name="immune_support_index_min")
m.addConstr(-9 * calcium + 10 * vitamin_E >= 0, name="calcium_vitamin_E_balance")
m.addConstr(20 * calcium + 13 * vitamin_E <= 231, name="immune_support_index_max")

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Milligrams of Calcium: {calcium.varValue}")
    print(f"Milligrams of Vitamin E: {vitamin_E.varValue}")
    print(f"Objective Value: {m.objVal}")
else:
    print("The model is infeasible or has no solution.")
