
from gurobipy import Model, GRB

# Create a new model
m = Model("Military Optimization")

# Create variables
recon_troops = m.addVar(vtype=GRB.INTEGER, name="recon_troops")
light_infantry = m.addVar(vtype=GRB.INTEGER, name="light_infantry")

# Set objective function
m.setObjective(9 * recon_troops + 5 * light_infantry, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8.6 * recon_troops + 2.79 * light_infantry >= 45, "fun_factor_min")
m.addConstr(9 * recon_troops - 5 * light_infantry >= 0, "troop_ratio")
m.addConstr(8.6 * recon_troops + 2.79 * light_infantry <= 83, "fun_factor_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Reconnaissance Troops: {recon_troops.x}")
    print(f"  Light Infantry Companies: {light_infantry.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

