
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
x1 = m.addVar(vtype=GRB.INTEGER, name="light_infantry_companies")

# Objective function: Maximize 9*x0 + 5*x1
m.setObjective(9*x0 + 5*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(8.6*x0 + 2.79*x1 >= 45, name="min_fun_factor")
m.addConstr(9*x0 - 5*x1 >= 0, name="troops_vs_companies")
m.addConstr(8.6*x0 + 2.79*x1 <= 83, name="max_fun_factor")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Reconnaissance Troops: {x0.x}")
    print(f"Light Infantry Companies: {x1.x}")
    print(f"Objective Value: {m.objVal}")
else:
    print("No optimal solution found.")
