
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    # Reconnaissance troops: continuous (as it can be non-fractional)
    # Light infantry companies: integer
    recon_troops = model.addVar(lb=0, name="reconnaissance_troops", vtype=gurobi.GRB.CONTINUOUS)
    light_infantry_companies = model.addVar(lb=0, name="light_infantry_companies", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 9 * recon_troops + 5 * light_infantry_companies
    model.setObjective(9 * recon_troops + 5 * light_infantry_companies, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Fun factor constraints
    fun_factor_recon = 8.6 * recon_troops
    fun_factor_light_infantry = 2.79 * light_infantry_companies
    total_fun_factor = fun_factor_recon + fun_factor_light_infantry

    model.addConstr(total_fun_factor >= 45, name="min_fun_factor")
    model.addConstr(total_fun_factor <= 83, name="max_fun_factor")

    # Mathematical constraint: 9 * recon_troops - 5 * light_infantry_companies >= 0
    model.addConstr(9 * recon_troops - 5 * light_infantry_companies >= 0, name="troops_balance")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Reconnaissance Troops: {recon_troops.varValue}")
        print(f"Light Infantry Companies: {light_infantry_companies.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model did not converge.")

solve_optimization_problem()
