
import gurobipy as gp

# Create a new model
model = gp.Model("WorkOptimization")

# Create variables
mary_hours = model.addVar(vtype=gp.GRB.INTEGER, name="mary_hours")
bobby_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bobby_hours")

# Set objective function
model.setObjective(6.47 * mary_hours + 9.14 * bobby_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * mary_hours + 1 * bobby_hours >= 30, "paperwork_rating_min")
model.addConstr(7 * mary_hours + 1 * bobby_hours <= 71, "paperwork_rating_max")
model.addConstr(8 * mary_hours - 5 * bobby_hours >= 0, "hours_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Mary's hours: {mary_hours.x}")
    print(f"  Bobby's hours: {bobby_hours.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

