
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    M = model.addVar(name="hours_worked_by_Mary", vtype=gurobi.GRB.INTEGER)  # Integer hours for Mary
    B = model.addVar(name="hours_worked_by_Bobby")  # Continuous hours for Bobby

    # Objective function: Minimize 6.47M + 9.14B
    model.setObjective(6.47 * M + 9.14 * B, gurobi.GRB.MINIMIZE)

    # Constraints
    # Mary's paperwork competence rating is 7
    model.addConstraint(7 * M + 1 * B >= 30, name="min_paperwork_rating")
    # The total combined paperwork competence rating must be 71 or less
    model.addConstraint(7 * M + 1 * B <= 71, name="max_paperwork_rating")
    # 8M - 5B >= 0
    model.addConstraint(8 * M - 5 * B >= 0, name="hourly_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal hours worked by Mary: {M.varValue}")
        print(f"Optimal hours worked by Bobby: {B.varValue}")
        print(f"Optimal objective value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
