
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
bananas = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")
apple_pies = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")
cherry_pies = model.addVar(lb=0, vtype=GRB.INTEGER, name="cherry_pies")
green_beans = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="green_beans")

# Set objective function
model.setObjective(4 * bananas + 9 * apple_pies + 2 * cherry_pies + 8 * green_beans, GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * apple_pies + 9 * green_beans >= 18, "c1")
model.addConstr(10 * bananas + 20 * cherry_pies >= 21, "c2")
model.addConstr(20 * cherry_pies + 9 * green_beans >= 37, "c3")
model.addConstr(10 * bananas + 20 * cherry_pies + 9 * green_beans >= 40, "c4")
model.addConstr(10 * bananas + 7 * apple_pies + 20 * cherry_pies >= 40, "c5")
model.addConstr(10 * bananas + 20 * cherry_pies + 9 * green_beans >= 33, "c6")
model.addConstr(10 * bananas + 7 * apple_pies + 20 * cherry_pies >= 33, "c7")
model.addConstr(10 * bananas + 7 * apple_pies + 20 * cherry_pies + 9 * green_beans >= 33, "c8")
model.addConstr(22 * apple_pies + 6 * green_beans >= 33, "c9")
model.addConstr(2 * bananas + 7 * cherry_pies >= 35, "c10")
model.addConstr(2 * bananas + 22 * apple_pies + 6 * green_beans >= 28, "c11")
model.addConstr(2 * bananas + 22 * apple_pies + 7 * cherry_pies >= 28, "c12")
model.addConstr(2 * bananas + 22 * apple_pies + 6 * green_beans >= 33, "c13")
model.addConstr(2 * bananas + 22 * apple_pies + 7 * cherry_pies >= 33, "c14")
model.addConstr(2 * bananas + 22 * apple_pies + 7 * cherry_pies + 6 * green_beans >= 33, "c15")
model.addConstr(-8 * bananas + 10 * green_beans >= 0, "c16")
model.addConstr(8 * bananas - 2 * apple_pies >= 0, "c17")
model.addConstr(-3 * bananas + 9 * cherry_pies + 4 * green_beans >= 0, "c18")
model.addConstr(10 * bananas + 20 * cherry_pies + 9 * green_beans <= 45, "c19")
model.addConstr(7 * apple_pies + 20 * cherry_pies + 9 * green_beans <= 82, "c20")
model.addConstr(10 * bananas + 7 * apple_pies + 20 * cherry_pies <= 53, "c21")
model.addConstr(22 * apple_pies + 6 * green_beans <= 122, "c22")


# Add resource constraints based on the provided dictionary
resource_constraints = {
    'r0': {'upper_bound': 169, 'x0': 10, 'x1': 7, 'x2': 20, 'x3': 9},
    'r1': {'upper_bound': 212, 'x0': 2, 'x1': 22, 'x2': 7, 'x3': 6}
}

for resource, data in resource_constraints.items():
    model.addConstr(data['x0'] * bananas + data['x1'] * apple_pies + data['x2'] * cherry_pies + data['x3'] * green_beans <= data['upper_bound'], resource)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

