
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
kale_salads = m.addVar(lb=0, name="kale_salads")
instant_ramen = m.addVar(lb=0, name="instant_ramen")
green_beans = m.addVar(lb=0, name="green_beans")
cereal = m.addVar(lb=0, name="cereal")

# Set objective function
m.setObjective(8.28 * kale_salads + 9.48 * instant_ramen + 6.68 * green_beans + 2.59 * cereal, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * kale_salads + 1 * instant_ramen >= 34, "tastiness_constraint1")
m.addConstr(6 * kale_salads + 3 * green_beans >= 52, "tastiness_constraint2")
m.addConstr(6 * kale_salads + 5 * cereal >= 23, "tastiness_constraint3")
m.addConstr(6 * kale_salads + 1 * instant_ramen + 3 * green_beans + 5 * cereal >= 23, "tastiness_constraint4")

m.addConstr(1 * instant_ramen + 2 * green_beans >= 22, "sourness_constraint1")
m.addConstr(1 * instant_ramen + 9 * cereal >= 20, "sourness_constraint2")
m.addConstr(3 * kale_salads + 2 * green_beans >= 34, "sourness_constraint3")
m.addConstr(3 * kale_salads + 9 * cereal >= 15, "sourness_constraint4")
m.addConstr(3 * kale_salads + 1 * instant_ramen + 2 * green_beans + 9 * cereal >= 15, "sourness_constraint5")


m.addConstr(2 * instant_ramen + 10 * cereal >= 14, "iron_constraint1")
m.addConstr(2 * instant_ramen + 10 * green_beans >= 19, "iron_constraint2")
m.addConstr(10 * green_beans + 10 * cereal >= 8, "iron_constraint3")
m.addConstr(6 * kale_salads + 10 * cereal >= 17, "iron_constraint4")
m.addConstr(6 * kale_salads + 2 * instant_ramen + 10 * green_beans + 10 * cereal >= 17, "iron_constraint5")

m.addConstr(9 * instant_ramen - 10 * green_beans >= 0, "misc_constraint1")

m.addConstr(1 * instant_ramen + 5 * cereal <= 207, "tastiness_constraint5")
m.addConstr(6 * kale_salads + 3 * green_beans <= 211, "tastiness_constraint6")
m.addConstr(6 * kale_salads + 5 * cereal <= 203, "tastiness_constraint7")
m.addConstr(6 * kale_salads + 1 * instant_ramen <= 166, "tastiness_constraint8")
m.addConstr(3 * green_beans + 5 * cereal <= 133, "tastiness_constraint9")
m.addConstr(6 * kale_salads + 1 * instant_ramen + 3 * green_beans <= 87, "tastiness_constraint10")

m.addConstr(6 * kale_salads + 10 * cereal <= 49, "iron_constraint6")
m.addConstr(2 * instant_ramen + 10 * green_beans <= 79, "iron_constraint7")
m.addConstr(6 * kale_salads + 2 * instant_ramen <= 65, "iron_constraint8")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

