
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
cheeseburgers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
ham_sandwiches = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")
blueberry_pies = m.addVar(vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")
corn_cobs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="corn_cobs")

# Set objective function
m.setObjective(4.45 * cheeseburgers + 7.62 * ham_sandwiches + 3.95 * blueberry_pies + 6.3 * corn_cobs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * ham_sandwiches + 14 * blueberry_pies >= 39, "c1")
m.addConstr(6 * cheeseburgers + 13 * corn_cobs >= 59, "c2")
m.addConstr(12 * blueberry_pies + 8 * corn_cobs >= 70, "c3")
m.addConstr(1 * cheeseburgers + 12 * blueberry_pies >= 40, "c4")
m.addConstr(5 * ham_sandwiches + 8 * corn_cobs >= 72, "c5")
m.addConstr(5 * ham_sandwiches + 12 * blueberry_pies >= 27, "c6")
m.addConstr(-7 * cheeseburgers + 2 * ham_sandwiches + 6 * blueberry_pies >= 0, "c7")
m.addConstr(3 * ham_sandwiches + 14 * blueberry_pies <= 122, "c8")
m.addConstr(14 * blueberry_pies + 13 * corn_cobs <= 145, "c9")
m.addConstr(3 * ham_sandwiches + 13 * corn_cobs <= 205, "c10")
m.addConstr(6 * cheeseburgers + 13 * corn_cobs <= 76, "c11")
m.addConstr(6 * cheeseburgers + 14 * blueberry_pies <= 241, "c12")
m.addConstr(6 * cheeseburgers + 3 * ham_sandwiches <= 144, "c13")
m.addConstr(6 * cheeseburgers + 3 * ham_sandwiches + 14 * blueberry_pies + 13 * corn_cobs <= 144, "c14")
m.addConstr(1 * cheeseburgers + 8 * corn_cobs <= 169, "c15")
m.addConstr(1 * cheeseburgers + 5 * ham_sandwiches <= 272, "c16")
m.addConstr(12 * blueberry_pies + 8 * corn_cobs <= 209, "c17")
m.addConstr(5 * ham_sandwiches + 12 * blueberry_pies <= 101, "c18")
m.addConstr(1 * cheeseburgers + 5 * ham_sandwiches + 8 * corn_cobs <= 135, "c19")
m.addConstr(1 * cheeseburgers + 5 * ham_sandwiches + 12 * blueberry_pies + 8 * corn_cobs <= 135, "c20")
m.addConstr(6 * cheeseburgers + 3 * ham_sandwiches + 14 * blueberry_pies + 13 * corn_cobs <= 262, "carbohydrate_limit") # Resource constraint r0
m.addConstr(1 * cheeseburgers + 5 * ham_sandwiches + 12 * blueberry_pies + 8 * corn_cobs <= 289, "healthiness_limit") # Resource constraint r1


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

