
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    cheeseburgers = model.addVar(lb=0, name="cheeseburgers", vtype=gurobi.GRB.CONTINUOUS)
    ham_sandwiches = model.addVar(lb=0, name="ham_sandwiches", vtype=gurobi.GRB.CONTINUOUS)
    blueberry_pies = model.addVar(lb=0, name="blueberry_pies", vtype=gurobi.GRB.CONTINUOUS)
    corn_cobs = model.addVar(lb=0, name="corn_cobs", vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(4.45 * cheeseburgers + 7.62 * ham_sandwiches + 3.95 * blueberry_pies + 6.3 * corn_cobs, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6 * cheeseburgers + 3 * ham_sandwiches + 14 * blueberry_pies + 13 * corn_cobs <= 262, name="carbohydrates")
    model.addConstr(1 * cheeseburgers + 5 * ham_sandwiches + 12 * blueberry_pies + 8 * corn_cobs <= 289, name="healthiness_rating")
    model.addConstr(3 * ham_sandwiches + 14 * blueberry_pies >= 39, name="ham_sandwiches_blueberry_pies_carbohydrates")
    model.addConstr(6 * cheeseburgers + 13 * corn_cobs >= 59, name="cheeseburgers_corn_cobs_carbohydrates")
    model.addConstr(12 * blueberry_pies + 8 * corn_cobs >= 70, name="blueberry_pies_corn_cobs_healthiness")
    model.addConstr(1 * cheeseburgers + 12 * blueberry_pies >= 40, name="cheeseburgers_blueberry_pies_healthiness")
    model.addConstr(5 * ham_sandwiches + 8 * corn_cobs >= 72, name="ham_sandwiches_corn_cobs_healthiness")
    model.addConstr(5 * ham_sandwiches + 12 * blueberry_pies >= 27, name="ham_sandwiches_blueberry_pies_healthiness")
    model.addConstr(-7 * cheeseburgers + 2 * ham_sandwiches + 6 * blueberry_pies >= 0, name="linear_constraint")
    model.addConstr(3 * ham_sandwiches + 14 * blueberry_pies <= 122, name="ham_sandwiches_blueberry_pies_carbohydrates_upper")
    model.addConstr(14 * blueberry_pies + 13 * corn_cobs <= 145, name="blueberry_pies_corn_cobs_carbohydrates_upper")
    model.addConstr(3 * ham_sandwiches + 13 * corn_cobs <= 205, name="ham_sandwiches_corn_cobs_carbohydrates_upper")
    model.addConstr(6 * cheeseburgers + 13 * corn_cobs <= 76, name="cheeseburgers_corn_cobs_carbohydrates_upper")
    model.addConstr(6 * cheeseburgers + 14 * blueberry_pies <= 241, name="cheeseburgers_blueberry_pies_carbohydrates_upper")
    model.addConstr(6 * cheeseburgers + 3 * ham_sandwiches <= 144, name="cheeseburgers_ham_sandwiches_carbohydrates_upper")
    model.addConstr(6 * cheeseburgers + 3 * ham_sandwiches + 14 * blueberry_pies + 13 * corn_cobs <= 144, name="total_carbohydrates_upper")
    model.addConstr(1 * cheeseburgers + 8 * corn_cobs <= 169, name="cheeseburgers_corn_cobs_healthiness_upper")
    model.addConstr(1 * cheeseburgers + 5 * ham_sandwiches <= 272, name="cheeseburgers_ham_sandwiches_healthiness_upper")
    model.addConstr(12 * blueberry_pies + 8 * corn_cobs <= 209, name="blueberry_pies_corn_cobs_healthiness_upper")
    model.addConstr(5 * ham_sandwiches + 12 * blueberry_pies <= 101, name="ham_sandwiches_blueberry_pies_healthiness_upper")
    model.addConstr(1 * cheeseburgers + 5 * ham_sandwiches + 8 * corn_cobs <= 135, name="cheeseburgers_ham_sandwiches_corn_cobs_healthiness_upper")
    model.addConstr(1 * cheeseburgers + 5 * ham_sandwiches + 12 * blueberry_pies + 8 * corn_cobs <= 135, name="total_healthiness_upper")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cheeseburgers: {cheeseburgers.varValue}")
        print(f"Ham sandwiches: {ham_sandwiches.varValue}")
        print(f"Blueberry pies: {blueberry_pies.varValue}")
        print(f"Corn cobs: {corn_cobs.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
