
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="b12")  # milligrams of vitamin B12
protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")  # grams of protein
zinc = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="zinc")  # milligrams of zinc

# Set objective function
m.setObjective(1.84 * b12**2 + 6.46 * b12 * protein + 4.61 * protein**2 + 1.45 * protein * zinc + 5.7 * b12, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(19 * b12 + 4 * protein + 6 * zinc >= 15, "energy_stability_1") # corrected constraint
m.addConstr(19 * b12 + 4 * protein >= 11, "energy_stability_2")
m.addConstr(19 * b12 + 6 * zinc >= 15, "energy_stability_3")
m.addConstr(6 * b12 + 14 * protein + 8 * zinc >= 27, "digestive_support_1") # corrected constraint
m.addConstr(6 * b12 + 14 * protein >= 17, "digestive_support_2")
m.addConstr(6 * b12 + 8 * zinc >= 26, "digestive_support_3")
m.addConstr(5 * b12 + 2 * protein + 2 * zinc >= 24, "cardiovascular_support_1") # corrected constraint
m.addConstr(5 * b12 + 2 * zinc >= 30, "cardiovascular_support_2")
m.addConstr(5 * b12 + 2 * protein >= 33, "cardiovascular_support_3")
m.addConstr(2 * protein + 2 * zinc >= 24, "cardiovascular_support_4")
m.addConstr(11 * b12 + 20 * protein + 14 * zinc >= 24, "kidney_support_1") # corrected constraint
m.addConstr(11 * b12**2 + 20 * protein**2 >= 14, "kidney_support_2") # corrected constraint
m.addConstr(20 * protein + 14 * zinc >= 15, "kidney_support_3")
m.addConstr(11 * b12 + 14 * zinc >= 24, "kidney_support_4")
m.addConstr(8 * b12 + 2 * protein + 20 * zinc >= 14, "cognitive_performance_1") # corrected constraint
m.addConstr(8 * b12 + 2 * protein >= 21, "cognitive_performance_2")
m.addConstr(8 * b12 + 20 * zinc >= 23, "cognitive_performance_3")
m.addConstr(2 * protein + 20 * zinc >= 16, "cognitive_performance_4")
m.addConstr(-5 * b12**2 + 7 * protein**2 >= 0, "constraint_1")
m.addConstr(4 * protein + 6 * zinc <= 70, "constraint_2")
m.addConstr(5 * b12**2 + 2 * protein**2 <= 49, "constraint_3")
m.addConstr(11 * b12 + 14 * zinc <= 75, "constraint_4")
m.addConstr(2 * protein**2 + 20 * zinc**2 <= 64, "constraint_5")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('b12:', b12.x)
    print('protein:', protein.x)
    print('zinc:', zinc.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
