
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="milligrams_of_vitamin_B12", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="grams_of_protein", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="milligrams_of_zinc", lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(1.84*x0**2 + 6.46*x0*x1 + 4.61*x1**2 + 1.45*x1*x2 + 5.7*x0, gp.GRB.MINIMIZE)

# Constraints
# Individual indices
m.addConstr(19*x0 + 4*x1 + 6*x2 <= 84)
m.addConstr(6*x0 + 14*x1 + 8*x2 <= 107)
m.addConstr(5*x0 + 2*x1 + 2*x2 <= 107)
m.addConstr(11*x0 + 20*x1 + 14*x2 <= 83)
m.addConstr(8*x0 + 2*x1 + 20*x2 <= 80)

# Energy stability index constraints
m.addConstr(19*x0 + 4*x1 >= 11)
m.addConstr(19*x0 + 6*x2 >= 15)
m.addConstr(19*x0 + 4*x1 + 6*x2 >= 15)

# Digestive support index constraints
m.addConstr(6*x0 + 14*x1 >= 17)
m.addConstr(6*x0 + 8*x2 >= 26)
m.addConstr(6*x0 + 14*x1 + 8*x2 >= 27)
m.addConstr(6*x0**2 + 14*x1**2 + 8*x2**2 >= 27)

# Cardiovascular support index constraints
m.addConstr(5*x0 + 2*x2 >= 30)
m.addConstr(5*x0 + 2*x1 >= 33)
m.addConstr(2*x1 + 2*x2 >= 24)
m.addConstr(5*x0 + 2*x1 + 2*x2 >= 24)

# Kidney support index constraints
m.addConstr(11*x0**2 + 20*x1**2 >= 14)
m.addConstr(20*x1 + 14*x2 >= 15)
m.addConstr(11*x0 + 14*x2 >= 24)
m.addConstr(11*x0 + 20*x1 + 14*x2 >= 24)

# Cognitive performance index constraints
m.addConstr(8*x0 + 2*x1 >= 21)
m.addConstr(8*x0 + 20*x2 >= 23)
m.addConstr(2*x1 + 20*x2 >= 16)
m.addConstr(8*x0 + 2*x1 + 20*x2 >= 14)

# Additional constraints
m.addConstr(-5*x0**2 + 7*x1**2 >= 0)
m.addConstr(4*x1 + 6*x2 <= 70)
m.addConstr(5*x0**2 + 2*x1**2 <= 49)
m.addConstr(11*x0 + 14*x2 <= 75)
m.addConstr(2*x1**2 + 20*x2**2 <= 64)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B12: {x0.varValue}")
    print(f"Grams of protein: {x1.varValue}")
    print(f"Milligrams of zinc: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
