
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
lemons = model.addVar(vtype=GRB.INTEGER, name="lemons")
chicken_thighs = model.addVar(vtype=GRB.INTEGER, name="chicken_thighs")
corn_cobs = model.addVar(vtype=GRB.CONTINUOUS, name="corn_cobs")
cheeseburgers = model.addVar(vtype=GRB.CONTINUOUS, name="cheeseburgers")

# Set objective function
model.setObjective(4.27 * lemons + 7.35 * chicken_thighs + 1.78 * corn_cobs + 6.68 * cheeseburgers, GRB.MAXIMIZE)

# Add carbohydrate constraints
model.addConstr(8.84 * chicken_thighs + 9.92 * corn_cobs + 7.71 * cheeseburgers >= 32, "c1")
model.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 9.92 * corn_cobs >= 32, "c2")
model.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 7.71 * cheeseburgers >= 32, "c3")
model.addConstr(8.84 * chicken_thighs + 9.92 * corn_cobs + 7.71 * cheeseburgers >= 52, "c4")
model.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 9.92 * corn_cobs >= 52, "c5")
model.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 7.71 * cheeseburgers >= 52, "c6")
model.addConstr(8.84 * chicken_thighs + 9.92 * corn_cobs + 7.71 * cheeseburgers >= 47, "c7")
model.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 9.92 * corn_cobs >= 47, "c8")
model.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 7.71 * cheeseburgers >= 47, "c9")
model.addConstr(9.92 * corn_cobs + 7.71 * cheeseburgers <= 196, "c10")
model.addConstr(4.64 * lemons + 7.71 * cheeseburgers <= 190, "c11")
model.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 7.71 * cheeseburgers <= 236, "c12")
model.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 9.92 * corn_cobs <= 204, "c13")
model.addConstr(4.64 * lemons + 8.84 * chicken_thighs + 9.92 * corn_cobs + 7.71 * cheeseburgers <= 204, "c14")


# Add calcium constraints
model.addConstr(6.51 * chicken_thighs + 5.58 * corn_cobs >= 49, "calcium1")
model.addConstr(4.0 * lemons + 6.51 * chicken_thighs + 1.41 * cheeseburgers >= 43, "calcium2")
model.addConstr(6.51 * chicken_thighs + 5.58 * corn_cobs + 1.41 * cheeseburgers >= 43, "calcium3")
model.addConstr(4.0 * lemons + 6.51 * chicken_thighs + 1.41 * cheeseburgers >= 47, "calcium4")
model.addConstr(6.51 * chicken_thighs + 5.58 * corn_cobs + 1.41 * cheeseburgers >= 47, "calcium5")
model.addConstr(4.0 * lemons + 5.58 * corn_cobs <= 60, "calcium6")
model.addConstr(4.0 * lemons + 6.51 * chicken_thighs <= 69, "calcium7")
model.addConstr(4.0 * lemons + 1.41 * cheeseburgers <= 163, "calcium8")
model.addConstr(4.0 * lemons + 6.51 * chicken_thighs + 5.58 * corn_cobs <= 94, "calcium9")
model.addConstr(4.0 * lemons + 5.58 * corn_cobs + 1.41 * cheeseburgers <= 136, "calcium10")
model.addConstr(6.51 * chicken_thighs + 5.58 * corn_cobs + 1.41 * cheeseburgers <= 169, "calcium11")
model.addConstr(4.0 * lemons + 6.51 * chicken_thighs + 1.41 * cheeseburgers <= 211, "calcium12")
model.addConstr(4.0 * lemons + 6.51 * chicken_thighs + 5.58 * corn_cobs + 1.41 * cheeseburgers <= 211, "calcium13")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
