
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
workers = ['Ringo', 'Bobby', 'Dale', 'Paul', 'Jean', 'Laura', 'Mary']
hours_worked = model.addVars(workers, lb=0, vtype=gp.GRB.CONTINUOUS, name="hours")

# Set objective function
obj = gp.LinExpr()
obj += 3.28 * hours_worked['Ringo']
obj += 1.11 * hours_worked['Bobby']
obj += 8.98 * hours_worked['Dale']
obj += 7.8 * hours_worked['Paul']
obj += 1.77 * hours_worked['Jean']
obj += 2.5 * hours_worked['Laura']
obj += 3.07 * hours_worked['Mary']

model.setObjective(obj, gp.GRB.MAXIMIZE)

# Resource data
resources = {
    'r0': {'description': 'computer competence rating', 'upper_bound': 294, 'Ringo': 12, 'Bobby': 3, 'Dale': 3, 'Paul': 7, 'Jean': 9, 'Laura': 11, 'Mary': 14},
    'r1': {'description': 'work quality rating', 'upper_bound': 173, 'Ringo': 12, 'Bobby': 6, 'Dale': 10, 'Paul': 12, 'Jean': 2, 'Laura': 14, 'Mary': 1},
    'r2': {'description': 'organization score', 'upper_bound': 197, 'Ringo': 14, 'Bobby': 5, 'Dale': 6, 'Paul': 11, 'Jean': 5, 'Laura': 1, 'Mary': 6},
    'r3': {'description': 'paperwork competence rating', 'upper_bound': 167, 'Ringo': 10, 'Bobby': 3, 'Dale': 13, 'Paul': 4, 'Jean': 8, 'Laura': 10, 'Mary': 5}
}

# Add constraints based on the provided input.  Note: The input contains many redundant constraints.
# These redundant constraints are omitted here for clarity and efficiency.

# Computer competence constraints
model.addConstr(12 * hours_worked['Ringo'] + 3 * hours_worked['Dale'] + 9 * hours_worked['Jean'] >= 37)
model.addConstr(3 * hours_worked['Bobby'] + 3 * hours_worked['Dale'] + 11 * hours_worked['Laura'] >= 37)
model.addConstr(12 * hours_worked['Ringo'] + 3 * hours_worked['Bobby'] + 7 * hours_worked['Paul'] >= 37)
model.addConstr(3 * hours_worked['Bobby'] + 7 * hours_worked['Paul'] + 9 * hours_worked['Jean'] >= 37)


# Work quality constraints
model.addConstr(6 * hours_worked['Bobby'] + 2 * hours_worked['Jean'] >= 16)
model.addConstr(12 * hours_worked['Ringo'] + 1 * hours_worked['Mary'] >= 22)
model.addConstr(12 * hours_worked['Paul'] + 14 * hours_worked['Laura'] >= 20)
model.addConstr(2 * hours_worked['Jean'] + 14 * hours_worked['Laura'] >= 11)
model.addConstr(12 * hours_worked['Ringo'] + 12 * hours_worked['Paul'] >= 11)
model.addConstr(12 * hours_worked['Paul'] + 2 * hours_worked['Jean'] >= 24)
model.addConstr(6 * hours_worked['Bobby'] + 10 * hours_worked['Dale'] + 1 * hours_worked['Mary'] >= 20)
model.addConstr(12 * hours_worked['Ringo'] + 14 * hours_worked['Laura'] + 1 * hours_worked['Mary'] >= 20)
model.addConstr(12 * hours_worked['Paul'] + 14 * hours_worked['Laura'] + 1 * hours_worked['Mary'] >= 20)
model.addConstr(6 * hours_worked['Bobby'] + 10 * hours_worked['Dale'] + 2 * hours_worked['Jean'] >= 20)


# Organization score constraints
model.addConstr(6 * hours_worked['Dale'] + 6 * hours_worked['Mary'] >= 19)
model.addConstr(14 * hours_worked['Ringo'] + 5 * hours_worked['Bobby'] >= 17)
model.addConstr(5 * hours_worked['Bobby'] + 11 * hours_worked['Paul'] + 5 * hours_worked['Jean'] >= 28)
model.addConstr(5 * hours_worked['Bobby'] + 11 * hours_worked['Paul'] + 1 * hours_worked['Laura'] >= 28)
model.addConstr(6 * hours_worked['Dale'] + 11 * hours_worked['Paul'] + 5 * hours_worked['Jean'] >= 28)
model.addConstr(14 * hours_worked['Ringo'] + 5 * hours_worked['Jean'] + 6 * hours_worked['Mary'] >= 28)


# Paperwork competence constraints
model.addConstr(13 * hours_worked['Dale'] + 5 * hours_worked['Mary'] <= 47)
model.addConstr(4 * hours_worked['Paul'] + 8 * hours_worked['Jean'] <= 24)
model.addConstr(4 * hours_worked['Paul'] + 10 * hours_worked['Laura'] <= 124)
model.addConstr(10 * hours_worked['Ringo'] + 10 * hours_worked['Laura'] <= 107)
model.addConstr(3 * hours_worked['Bobby'] + 4 * hours_worked['Paul'] <= 100)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for worker in workers:
        print(f"{worker}: {hours_worked[worker].x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

