
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
R = m.addVar(name="Ringo", lb=0)  
B = m.addVar(name="Bobby", lb=0)  
D = m.addVar(name="Dale", lb=0)  
P = m.addVar(name="Paul", lb=0)  
J = m.addVar(name="Jean", lb=0)  
L = m.addVar(name="Laura", lb=0)  
M = m.addVar(name="Mary", lb=0)  

# Define the objective function
m.setObjective(3.28*R + 1.11*B + 8.98*D + 7.8*P + 1.77*J + 2.5*L + 3.07*M, gp.GRB.MAXIMIZE)

# Individual ratings
m.addConstr(12*R + 3*B + 3*D + 7*P + 9*J + 11*L + 14*M <= 294)
m.addConstr(12*R + 6*B + 10*D + 12*P + 2*J + 14*L + 1*M <= 173)
m.addConstr(14*R + 5*B + 6*D + 11*P + 5*J + 1*L + 6*M <= 197)
m.addConstr(10*R + 3*B + 13*D + 4*P + 8*J + 10*L + 5*M <= 167)

m.addConstr(12*R >= 12)
m.addConstr(12*B >= 6)
m.addConstr(10*D >= 10)
m.addConstr(12*P >= 12)
m.addConstr(2*J >= 2)
m.addConstr(14*M >= 1)

m.addConstr(3*B + 3*D + 7*P + 9*J + 11*L + 14*M >= 23)
m.addConstr(3*D + 13*L >= 26)

# ... (rest of the constraints)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Ringo: {R.varValue}")
    print(f"Bobby: {B.varValue}")
    print(f"Dale: {D.varValue}")
    print(f"Paul: {P.varValue}")
    print(f"Jean: {J.varValue}")
    print(f"Laura: {L.varValue}")
    print(f"Mary: {M.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
