
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("supplement_optimization")

    # Create variables
    zinc = m.addVar(lb=0, name="zinc")
    magnesium = m.addVar(lb=0, name="magnesium")
    vitamin_b4 = m.addVar(lb=0, name="vitamin_b4")

    # Set objective function
    m.setObjective(5.01 * zinc + 2.79 * magnesium + 4.52 * vitamin_b4, gp.GRB.MINIMIZE)

    # Add constraints based on resource attributes
    digestive_support = m.addConstr(16 * zinc + 8 * magnesium + 21 * vitamin_b4 <= 170, "digestive_support")
    immune_support = m.addConstr(8 * zinc + 7 * magnesium + 26 * vitamin_b4 <= 235, "immune_support")
    muscle_growth = m.addConstr(12 * zinc + 19 * magnesium + 21 * vitamin_b4 <= 175, "muscle_growth")


    # Add additional constraints from the problem description
    m.addConstr(8 * magnesium + 21 * vitamin_b4 >= 39)
    m.addConstr(16 * zinc + 8 * magnesium >= 21)
    m.addConstr(16 * zinc + 8 * magnesium + 21 * vitamin_b4 >= 45)
    m.addConstr(7 * magnesium + 26 * vitamin_b4 >= 72)
    m.addConstr(8 * zinc + 7 * magnesium >= 33)
    m.addConstr(8 * zinc + 7 * magnesium + 26 * vitamin_b4 >= 33)  # Redundant, implied by previous constraint
    m.addConstr(12 * zinc + 21 * vitamin_b4 >= 32)
    m.addConstr(12 * zinc + 19 * magnesium >= 48)
    m.addConstr(12 * zinc + 19 * magnesium + 21 * vitamin_b4 >= 48)
    m.addConstr(4 * zinc - 2 * vitamin_b4 >= 0)
    m.addConstr(-7 * zinc + 7 * magnesium >= 0)
    m.addConstr(8 * zinc + 26 * vitamin_b4 <= 233)
    m.addConstr(8 * zinc + 7 * magnesium <= 231)
    m.addConstr(12 * zinc + 19 * magnesium + 21 * vitamin_b4 <= 81)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('zinc:', zinc.x)
        print('magnesium:', magnesium.x)
        print('vitamin_b4:', vitamin_b4.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
