
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
z = m.addVar(name="z", lb=0)  # milligrams of zinc
m_var = m.addVar(name="m", lb=0)  # milligrams of magnesium
v = m.addVar(name="v", lb=0)  # milligrams of vitamin B4

# Define the objective function
m.setObjective(5.01 * z + 2.79 * m_var + 4.52 * v, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16 * z + 8 * m_var + 21 * v <= 170)  # digestive support index
m.addConstr(8 * z + 7 * m_var + 26 * v <= 235)  # immune support index
m.addConstr(12 * z + 19 * m_var + 21 * v <= 175)  # muscle growth index
m.addConstr(8 * m_var + 21 * v >= 39)  # digestive support from magnesium and vitamin B4
m.addConstr(16 * z + 8 * m_var >= 21)  # digestive support from zinc and magnesium
m.addConstr(16 * z + 8 * m_var + 21 * v >= 45)  # digestive support from all
m.addConstr(7 * m_var + 26 * v >= 72)  # immune support from magnesium and vitamin B4
m.addConstr(8 * z + 7 * m_var >= 33)  # immune support from zinc and magnesium
m.addConstr(8 * z + 7 * m_var + 26 * v >= 33)  # immune support from all
m.addConstr(12 * z + 21 * v >= 32)  # muscle growth from zinc and vitamin B4
m.addConstr(12 * z + 19 * m_var >= 48)  # muscle growth from zinc and magnesium
m.addConstr(12 * z + 19 * m_var + 21 * v >= 48)  # muscle growth from all
m.addConstr(4 * z - 2 * v >= 0)  # relationship between zinc and vitamin B4
m.addConstr(-7 * z + 7 * m_var >= 0)  # relationship between zinc and magnesium
m.addConstr(8 * z + 26 * v <= 233)  # immune support from zinc and vitamin B4
m.addConstr(8 * z + 7 * m_var <= 231)  # immune support from zinc and magnesium
m.addConstr(12 * z + 19 * m_var + 21 * v <= 81)  # muscle growth from all

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of zinc: {z.varValue}")
    print(f"Milligrams of magnesium: {m_var.varValue}")
    print(f"Milligrams of vitamin B4: {v.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
